#ifndef _SOCKETSERVER_H
#define _SOCKETSERVER_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define MAXRECVSIZE          2048             // The max ammount of data that can be received at once.
#define RECEIVEBUFSZ         MAXRECVSIZE * 2  // The max ammount of data the client receive buffer can hold. 
#define MAXSENDBUFSZ         2048             // The max ammount of data the client send buffer can hold

#define PACKETHEADER         12345

#define TCPHANDLER_MS_WAIT   1
#define CLIENTTHREAD_MS_WAIT 1

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Used to pass class data to the client thread
typedef struct _CLIENTTHREADINFO{
    int Client;
}CLIENTTHREADINFO, *LPCLIENTTHREADINFO;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class SocketServer{

    public:
        bool DoConnect(char *sRemoteAddr, int iRemotePort, int *ioutClient);
        bool GetClientData(int iClient, char *outsBuf, int *outiSize);
        bool GetNextClientData(int iClient, char *outsBuf, int *outiSize);
        bool Initialize(int MaxClients);
        bool IsClientDataPending(int iClient);
        bool IsClientDataWaiting(int iClient);
        bool SetNextSendData(int iClient, char *sData);
        bool SetNextSendDataEx(int iClient, char *sData, int iSize);
        bool SetSendData(int iClient, char *sData);
        bool SetSendDataEx(int iClient, char *sData, int iSize);
        bool Start(int iListenPort);
        bool Stop(void);
        bool UnInitialize(void);
        bool WaitOnClientDataToBeRecvd(int iClient);
        bool WaitOnClientDataToBeSent(int iClient);
        int SendData(int iClient, char *sData);
        int SendDataEx(int iClient, char *sData, int iSize);
        void DropBadPacketData(int iClient, bool bDropBad);
        void SetRawStreamMode(int iClient, bool bRawMode);

		CRITICAL_SECTION CriticalSection1;

        //------------------------------------------------------------

    private:
        bool Close_ListenSocket(void);
        bool DisconnectClient(int iClient);
        bool DoAccept(void);
        bool DoRecv(int iClient);
        bool DoSend(int iClient);
        bool OnAcceptConnectClient(int iClient);
        bool OnDisconnectClient(int iClient);
        bool Open_ListenSocket(int iListenPort);
        bool Start_ClientThread(int iClient);
		bool OnBegin_ClientThread(int iClient);
		bool OnEnd_ClientThread(int iClient);
        bool Start_WindowsSocket(void);
        bool Stop_WindowsSocket(void);
        bool WaitOnClientThreadToExit(int iClient);
        int BreakClassPacket(int iClient, char *outBuf, int *iOutBufSz);
        int MakeClassPacket(char *outBuffer, const char *inBuffer, int inLength);
        int SelectFreeSocket(void); // Search for free client "Slot"

    public:
        //------------------------------------------------------------------------
        //Client specific items (Begin)
        //------------------------------------------------------------------------
        bool *bcDropBadPackets;  // Drop bad client packets
        bool *bcRawDataMode;     // Is this client using Raw or Packet data mode (True=Raw, False=Packet)
        bool *bcConnected;       // Remote client's connection flag
        bool *bcDisconnect;      // Remote client's disconnect flag
        char **scRecvBuf;        // Clients receive buffer
        char **scSendBuf;        // Clients send buffer
        int *icClientID;	     // Remote client's ID (For client identification)
        int *icRecvBufSz;        // The size of the content in the clients scRecvBuf
        int *icRecvOffset;       // Data offset (Used for packet data)
        int *icSendBufSz;        // The size of the content in the clients scSendBuf
       	SOCKET *sckcSocket;      // Remote client's socket

    private:
        friend DWORD WINAPI Client_Thread_Function(LPVOID pvThread);

        DWORD *dwcClient_Thread_ID;
        HANDLE *hcClient_Thread_Handle;

		CLIENTTHREADINFO CTI;
        //------------------------------------------------------------------------
        //Client specific items (End)
        //------------------------------------------------------------------------

        int icCurrentClients; // The amount of clients connected to the server
        int icMaxClients;     // Max clients allowed to connect
        int icNextClientID;   // The next assigned Client ID

        SOCKET sckcListenSocket; // Listen socket of local server

        fd_set ExceptFDS; // FDS Except
        fd_set ReadFDS;   // FDS Read
        fd_set WriteFDS;  // FDS Write

        struct timeval TimeOut;  // TimeOut

        bool IsListeningServer;

        //------------------------------------------------------------------------
        //The TCPHandler routine threading items (Begin)
        //------------------------------------------------------------------------
        friend DWORD WINAPI TCPHandler_Thread_Function(LPVOID pvThread);

        bool Start_TCPHandler(void);
        bool Stop_TCPHandler(void);

        bool bcShutdownTCPHandler;
        bool bcTCPHandlerActive;
        DWORD dwcTCPHandler_Thread_ID;
        HANDLE hcTCPHandler_Thread_Handle;
        //------------------------------------------------------------------------
        //The TCPHandler routine threading items (End)
        //------------------------------------------------------------------------
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Non-standard definitions (Begin)

extern SocketServer gServer;

//Non-standard definitions (End)
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

